/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.api.VWException;
import filenet.vw.api.VWQueue;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWQueueQuery;
import filenet.vw.api.VWWorkObject;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.VWAdminResultPane;
import filenet.vw.toolkit.admin.result.VWAdminWOTableModel;
import filenet.vw.toolkit.admin.result.VWAdminWorkObjectTableData;
import filenet.vw.toolkit.admin.search.VWAdminPerformSearchEvent;

public abstract class VWAdminWOInQueueTableModel
extends VWAdminWOTableModel {
    protected VWQueue m_vwQueue = null;
    protected VWWorkObject m_curQueueWorkObject = null;
    protected VWQueueQuery m_vwQueueQuery = null;
    protected String m_queueName = null;

    public VWAdminWOInQueueTableModel(VWAdminResultPane resultsPane, VWAdminPerformSearchEvent event) {
        super(resultsPane, event);
        try {
            this.m_queueName = event.getSelectedItem();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void startTheQuery() throws Exception {
        this.setQueryFlags(3 + this.m_queryFlags);
        this.setQueryFetchType(1);
        this.m_vwQueue = this.m_vwSession.getQueue(this.m_queueName);
        this.m_vwQueue.setBufferSize(this.m_maxReturned);
        this.m_vwQueueQuery = this.m_vwQueue.createQuery(this.m_queryIndexName, this.m_queryMinIndexValue, this.m_queryMaxIndexValue, this.m_queryFlags, this.m_queryFilter, this.m_querySubstitutionVars, this.m_queryFetchType);
        this.getExposedFieldsDefinition();
        this.initColumnsOrder();
    }

    protected int fetchQueryCount() throws Exception {
        int count = -1;
        try {
            this.setQueryFlags(3 + this.m_queryFlags);
            this.setQueryFetchType(1);
            this.m_vwQueue = this.m_vwSession.getQueue(this.m_queueName);
            this.m_vwQueue.setBufferSize(this.m_maxReturned);
            this.m_vwQueueQuery = this.m_vwQueue.createQuery(this.m_queryIndexName, this.m_queryMinIndexValue, this.m_queryMaxIndexValue, this.m_queryFlags, this.m_queryFilter, this.m_querySubstitutionVars, this.m_queryFetchType);
            count = this.m_vwQueueQuery.fetchCount();
        }
        catch (Exception ex) {
            count = -1;
            throw ex;
        }
        return count;
    }

    protected void retrieveWorkObjects() throws Exception {
        VWWorkObject curWorkObject = null;
        int rowNum = 0;
        try {
            if (this.m_objectCache != null) {
                this.m_objectCache.removeAllElements();
            }
            for (rowNum = 0; rowNum < this.m_maxReturned && (curWorkObject = (VWWorkObject)this.m_vwQueueQuery.next()) != null; ++rowNum) {
                VWAdminWorkObjectTableData dataField = new VWAdminWorkObjectTableData(curWorkObject, this.m_logonUser, false, rowNum + 1, rowNum);
                this.m_objectCache.addElement(dataField);
            }
            if (rowNum > 0) {
                ++this.m_setNum;
            }
            if (this.m_vwQueueQuery.hasNext()) {
                this.setHasNext(true);
            } else {
                this.setHasNext(false);
            }
        }
        catch (OutOfMemoryError err) {
            throw new VWException("vw.toolkit.admin.result.outOfMemoryError", "Out of memory.  Please use a smaller maximum returned set.");
        }
        catch (Exception ex) {
            throw ex;
        }
    }

    protected void getExposedFieldsDefinition() {
        VWQueueDefinition vwQueueDefinition = null;
        try {
            vwQueueDefinition = this.m_vwQueue.fetchQueueDefinition();
            this.m_vwFieldDefinitions = vwQueueDefinition == null ? null : vwQueueDefinition.getFields();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

